/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.ui.widget.tab;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.client.ui.UiHelper;
import dev.compactmods.crafting.client.ui.widget.IWidgetScreen;
import dev.compactmods.crafting.client.ui.widget.WidgetBase;
import dev.compactmods.crafting.client.ui.widget.renderable.IWidgetPostBackgroundRenderable;
import dev.compactmods.crafting.client.ui.widget.renderable.IWidgetPreBackgroundRenderable;
import dev.compactmods.crafting.client.ui.widget.tab.EnumTabWidgetSide;
import dev.compactmods.crafting.client.ui.widget.tab.GuiTab;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TabsWidget
extends WidgetBase
implements GuiEventListener,
IWidgetPreBackgroundRenderable,
IWidgetPostBackgroundRenderable {
    protected final ResourceLocation TEXTURE = new ResourceLocation("compactcrafting", "textures/gui/widget/tabs.png");
    protected final int ARROW_OFFSET_X = 130;
    protected final int ARROW_OFFSET_Y = 0;
    protected final int ARROW_OFFSET_DEFAULT = 0;
    protected final int ARROW_OFFSET_DISABLED = 1;
    protected final int ARROW_OFFSET_HOVERED = 2;
    protected final Vec2 ARROW_TEXTURE_SIZE = new Vec2(10.0f, 15.0f);
    private final ItemRenderer itemRenderer;
    protected Map<Integer, GuiTab> tabs;
    private IWidgetScreen parentScreen;
    private final float parentHeight;
    private EnumTabWidgetSide screenSide;
    private GuiTab activeTab;
    private int currentPage;
    private int numPages;

    public TabsWidget(IWidgetScreen screen, int width, int height) {
        super(width, height);
        this.parentScreen = screen;
        this.tabs = new HashMap<Integer, GuiTab>();
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        this.screenSide = EnumTabWidgetSide.TOP;
        this.parentHeight = this.parentScreen.getScreenSize().f_82471_;
        this.currentPage = 0;
        this.numPages = 0;
        this.activeTab = null;
    }

    public TabsWidget addTab(GuiTab tab) {
        boolean firstAdded = this.tabs.isEmpty();
        this.tabs.put(this.tabs.size(), tab);
        Vec2 bake = this.getTabPosition(tab);
        tab.setPosition(bake);
        if (firstAdded) {
            this.setActiveTab(tab);
        }
        this.layout();
        return this;
    }

    public void layout() {
        for (GuiTab tab : this.tabs.values()) {
            Vec2 bake = this.getTabPosition(tab);
            tab.setPosition(bake);
        }
        int numVisible = this.width / 28;
        this.numPages = this.tabs.size() / numVisible + 1;
    }

    public TabsWidget withSide(EnumTabWidgetSide side) {
        this.screenSide = side;
        return this;
    }

    protected Vec3 getRealRelativePos(double mouseX, double mouseY) {
        double realX = mouseX;
        double realY = mouseY;
        switch (this.screenSide) {
            case TOP: {
                realY = mouseY + 28.0;
                break;
            }
            case BOTTOM: {
                realY = (double)this.parentHeight - mouseY + 28.0;
            }
        }
        return new Vec3(realX, realY, 0.0);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        Vec3 realCoords = this.getRealRelativePos(mouseX, mouseY);
        return UiHelper.pointInBounds(realCoords.f_82479_, realCoords.f_82480_, 0.0, 0.0, this.width, this.height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Vec3 realCoords = this.getRealRelativePos(mouseX, mouseY);
        for (GuiTab tab : this.tabs.values()) {
            if (!tab.isOver(realCoords.f_82479_, realCoords.f_82480_)) continue;
            double tabX = realCoords.f_82479_ - (double)tab.screenPosition.f_82470_;
            double tabY = realCoords.f_82480_;
            tab.m_6375_(tabX, tabY, button);
        }
        return true;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Font font = Minecraft.m_91087_().f_91062_;
        String page = String.format("%d/%d", this.currentPage + 1, this.numPages);
        int width = font.m_92895_(page);
        int xOffset = this.width / 2 - width / 2;
        Objects.requireNonNull(font);
        int yOffset = -9 - 28 - 2;
        int yOffsetArrows = -28 - (int)this.ARROW_TEXTURE_SIZE.f_82471_;
        if (this.screenSide == EnumTabWidgetSide.BOTTOM) {
            matrixStack.m_85837_(0.0, (double)this.parentHeight, 0.0);
            yOffset = this.height + 4;
            yOffsetArrows = this.height + 1;
        }
        font.m_92889_(matrixStack, (Component)new TextComponent(page), (float)xOffset, (float)yOffset, -1);
        Minecraft.m_91087_().m_91097_().m_174784_(this.TEXTURE);
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        int parentWidth = (int)this.parentScreen.getScreenSize().f_82470_;
        int arrowLeft = parentWidth / 2 - (int)this.ARROW_TEXTURE_SIZE.f_82470_ - 20;
        int arrowRight = parentWidth / 2 + 20;
        float arrowLeftU = 130.0f;
        float arrowLeftV = 0.0f + this.ARROW_TEXTURE_SIZE.f_82471_;
        Vec3 realCoords = this.getRealRelativePos(mouseX, mouseY);
        boolean mouseOverAL = mouseX > 0 && mouseX <= 100;
        CompactCrafting.LOGGER.debug(String.format("%s,%s", mouseX, mouseY));
        if (mouseOverAL) {
            arrowLeftU += 2.0f * this.ARROW_TEXTURE_SIZE.f_82470_;
        }
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)arrowLeft, (int)yOffsetArrows, (int)0, (float)arrowLeftU, (float)arrowLeftV, (int)((int)this.ARROW_TEXTURE_SIZE.f_82470_), (int)((int)this.ARROW_TEXTURE_SIZE.f_82471_), (int)256, (int)256);
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)arrowRight, (int)yOffsetArrows, (int)0, (float)130.0f, (float)0.0f, (int)((int)this.ARROW_TEXTURE_SIZE.f_82470_), (int)((int)this.ARROW_TEXTURE_SIZE.f_82471_), (int)256, (int)256);
    }

    @Override
    public void renderPreBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.tabs.isEmpty()) {
            int numTabs = this.getNumberTabs();
            int numTabsPerRow = this.width / 28;
            int start = this.currentPage * numTabs;
            int end = Math.min(numTabs, numTabsPerRow * (this.currentPage + 1));
            matrixStack.m_85836_();
            if (this.screenSide == EnumTabWidgetSide.BOTTOM) {
                matrixStack.m_85837_(0.0, (double)this.parentHeight, 0.0);
            }
            for (int idx = start; idx < end; ++idx) {
                GuiTab tab = this.tabs.get(idx);
                if (this.isActive(tab)) continue;
                tab.renderPreBackground(matrixStack, mouseX, mouseY, partialTicks);
            }
            matrixStack.m_85849_();
        }
    }

    @Override
    public void renderPostBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.tabs.isEmpty()) {
            matrixStack.m_85836_();
            if (this.screenSide == EnumTabWidgetSide.BOTTOM) {
                matrixStack.m_85837_(0.0, (double)this.parentHeight, 0.0);
            }
            if (this.activeTab != null) {
                this.activeTab.renderPostBackground(matrixStack, mouseX, mouseY, partialTicks);
            }
            matrixStack.m_85849_();
        }
    }

    public int getNumberTabs() {
        return this.tabs.size();
    }

    public EnumTabWidgetSide getSide() {
        return this.screenSide;
    }

    protected int getTabIndex(GuiTab tab) {
        for (Map.Entry<Integer, GuiTab> t : this.tabs.entrySet()) {
            if (t.getValue() != tab) continue;
            return t.getKey();
        }
        return -1;
    }

    public Vec2 getTabPosition(GuiTab tab) {
        int index = this.getTabIndex(tab);
        if (index == -1) {
            return Vec2.f_82469_;
        }
        if (!tab.isOnRight()) {
            return new Vec2((float)(tab.getWidth() * index), 0.0f);
        }
        float x = this.width - tab.getWidth() * (this.tabs.size() - index);
        return new Vec2(x, 0.0f);
    }

    public boolean isActive(GuiTab tab) {
        if (this.activeTab == null) {
            return false;
        }
        return tab == this.activeTab;
    }

    public void setActiveTab(GuiTab tab) {
        this.activeTab = tab;
    }
}

